/*
 * Decompiled with CFR 0.152.
 */
package com.RT_Printer.WIFI;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;

public class WifiPrintDriver {
    private String ip = "192.168.8.1";
    private int port = 8080;
    public static Socket mysocket = null;
    public static OutputStream mWifiOutputStream = null;
    private static final int DEFAULT_CMD_BUFFER_LEN = 0x100000;
    private static int mIndex = 0;
    public static final int Code128_B = 732;
    private static byte[] mCmdBuffer = new byte[0x100000];

    public static boolean WIFISocket(String ip, int port) {
        boolean error = false;
        if (mysocket != null) {
            try {
                mysocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            mysocket = null;
        }
        try {
            mysocket = new Socket(ip, port);
            if (mysocket != null) {
                mWifiOutputStream = mysocket.getOutputStream();
            } else {
                mWifiOutputStream = null;
                error = true;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (error) {
            WifiPrintDriver.Close();
            return false;
        }
        return true;
    }

    public static boolean Close() {
        try {
            if (mWifiOutputStream != null) {
                mWifiOutputStream.close();
                mWifiOutputStream = null;
            }
            if (mysocket != null) {
                mysocket.close();
                mysocket = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean IsNoConnection() {
        return mWifiOutputStream == null;
    }

    public static boolean InitPrinter() {
        byte[] combyte;
        block3: {
            combyte = new byte[]{27, 64};
            if (mWifiOutputStream != null) break block3;
            return false;
        }
        try {
            mWifiOutputStream.write(combyte);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void ImportData(byte[] data, int dataLen) {
        int DataLength = dataLen;
        int i = 0;
        while (i < DataLength) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = data[i];
            ++i;
        }
    }

    public static void ImportData(String dataString) {
        byte[] data = null;
        try {
            data = dataString.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int DataLength = data.length;
        int i = 0;
        while (i < DataLength) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = data[i];
            ++i;
        }
    }

    public static void ImportData(String dataString, boolean bGBK) {
        byte[] data = null;
        if (bGBK) {
            try {
                data = dataString.getBytes("GBK");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            data = dataString.getBytes();
        }
        int DataLength = data.length;
        int i = 0;
        while (i < DataLength) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = data[i];
            ++i;
        }
    }

    public static void ClearData() {
        mIndex = 0;
    }

    public static void WakeUpPritner() {
        byte[] b = new byte[3];
        try {
            mWifiOutputStream.write(b);
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void Begin() {
        WifiPrintDriver.WakeUpPritner();
        WifiPrintDriver.InitPrinter();
        WifiPrintDriver.ClearData();
    }

    public static boolean excute() {
        if (mIndex > 0) {
            try {
                mWifiOutputStream.write(mCmdBuffer, 0, mIndex);
                mWifiOutputStream.flush();
                mIndex = 0;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    public static void LF() {
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 10;
    }

    public static void SetZoom(byte param) {
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 29;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 33;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = param;
    }

    public static void SetCharacterFont(byte param) {
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 27;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 77;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = param;
    }

    public static void SetUnderline(byte param) {
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 27;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 45;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = param;
    }

    public static void AddBold(byte param) {
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 27;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 69;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = param;
    }

    public static void AddInverse(byte param) {
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 29;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 66;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = param;
    }

    public static void SetLineSpace(byte param) {
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 27;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 51;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 3;
    }

    public static void AddAlignMode(byte param) {
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 27;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 97;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = param;
    }

    public static void AddCodePrint(int CodeType, String data) {
        switch (CodeType) {
            case 732: {
                WifiPrintDriver.Code128_B(data);
                break;
            }
        }
    }

    public static void Code128_B(String data) {
        int m = 73;
        int num = data.length();
        int transNum = 0;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 29;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 107;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = (byte)m;
        int Code128C = mIndex++;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 123;
        WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 66;
        int i = 0;
        while (i < num) {
            if (data.charAt(i) > '\u007f' || data.charAt(i) < ' ') {
                return;
            }
            ++i;
        }
        if (num > 30) {
            return;
        }
        i = 0;
        while (i < num) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = (byte)data.charAt(i);
            if (data.charAt(i) == '{') {
                WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = (byte)data.charAt(i);
                ++transNum;
            }
            ++i;
        }
        int checkcodeID = 104;
        int n = 1;
        int i2 = 0;
        while (i2 < num) {
            checkcodeID += n++ * (data.charAt(i2) - 32);
            ++i2;
        }
        if ((checkcodeID %= 103) >= 0 && checkcodeID <= 95) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = (byte)(checkcodeID + 32);
            WifiPrintDriver.mCmdBuffer[Code128C] = (byte)(num + 3 + transNum);
        } else if (checkcodeID == 96) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 123;
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 51;
            WifiPrintDriver.mCmdBuffer[Code128C] = (byte)(num + 4 + transNum);
        } else if (checkcodeID == 97) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 123;
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 50;
            WifiPrintDriver.mCmdBuffer[Code128C] = (byte)(num + 4 + transNum);
        } else if (checkcodeID == 98) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 123;
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 83;
            WifiPrintDriver.mCmdBuffer[Code128C] = (byte)(num + 4 + transNum);
        } else if (checkcodeID == 99) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 123;
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 67;
            WifiPrintDriver.mCmdBuffer[Code128C] = (byte)(num + 4 + transNum);
        } else if (checkcodeID == 100) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 123;
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 52;
            WifiPrintDriver.mCmdBuffer[Code128C] = (byte)(num + 4 + transNum);
        } else if (checkcodeID == 101) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 123;
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 65;
            WifiPrintDriver.mCmdBuffer[Code128C] = (byte)(num + 4 + transNum);
        } else if (checkcodeID == 102) {
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 123;
            WifiPrintDriver.mCmdBuffer[WifiPrintDriver.mIndex++] = 49;
            WifiPrintDriver.mCmdBuffer[Code128C] = (byte)(num + 4 + transNum);
        }
    }

    public static boolean SPPWrite(byte[] Data, int DataLen) {
        try {
            mWifiOutputStream.write(Data, 0, DataLen);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean SPPWrite(byte[] buffer) {
        try {
            mWifiOutputStream.write(buffer);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static void printString(String str) {
        try {
            WifiPrintDriver.SPPWrite(str.getBytes("GBK"));
            WifiPrintDriver.SPPWrite(new byte[]{10});
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void printParameterSet(byte[] buf) {
        WifiPrintDriver.SPPWrite(buf);
    }

    public static void printByteData(byte[] buf) {
        WifiPrintDriver.SPPWrite(buf);
        WifiPrintDriver.SPPWrite(new byte[]{10});
    }

    public static void printImage() {
        WifiPrintDriver.printParameterSet(new byte[]{27, 64});
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 33;
        WifiPrintDriver.printParameterSet(byArray);
        byte[] byArray2 = new byte[2062];
        byArray2[0] = 27;
        byArray2[1] = 64;
        byArray2[2] = 27;
        byArray2[3] = 74;
        byArray2[4] = 24;
        byArray2[5] = 29;
        byArray2[6] = 118;
        byArray2[7] = 48;
        byArray2[9] = 16;
        byArray2[11] = -128;
        byArray2[145] = 32;
        byArray2[152] = 4;
        byArray2[161] = 96;
        byArray2[168] = 6;
        byArray2[177] = -32;
        byArray2[184] = 7;
        byArray2[192] = 1;
        byArray2[193] = -32;
        byArray2[200] = 7;
        byArray2[201] = -128;
        byArray2[208] = 3;
        byArray2[209] = -32;
        byArray2[216] = 7;
        byArray2[217] = -64;
        byArray2[224] = 7;
        byArray2[225] = -64;
        byArray2[232] = 3;
        byArray2[233] = -32;
        byArray2[240] = 15;
        byArray2[241] = -64;
        byArray2[248] = 3;
        byArray2[249] = -16;
        byArray2[256] = 31;
        byArray2[257] = -128;
        byArray2[259] = -64;
        byArray2[262] = 3;
        byArray2[264] = 1;
        byArray2[265] = -8;
        byArray2[272] = 63;
        byArray2[273] = -128;
        byArray2[274] = 1;
        byArray2[275] = -64;
        byArray2[278] = 3;
        byArray2[279] = -128;
        byArray2[280] = 1;
        byArray2[281] = -4;
        byArray2[288] = 127;
        byArray2[290] = 3;
        byArray2[291] = -64;
        byArray2[294] = 3;
        byArray2[295] = -64;
        byArray2[297] = -2;
        byArray2[304] = 127;
        byArray2[306] = 7;
        byArray2[307] = -64;
        byArray2[310] = 3;
        byArray2[311] = -32;
        byArray2[313] = -2;
        byArray2[320] = -1;
        byArray2[322] = 15;
        byArray2[323] = -128;
        byArray2[326] = 1;
        byArray2[327] = -16;
        byArray2[329] = -1;
        byArray2[335] = 1;
        byArray2[336] = -2;
        byArray2[338] = 31;
        byArray2[339] = -128;
        byArray2[342] = 1;
        byArray2[343] = -8;
        byArray2[345] = 127;
        byArray2[346] = -128;
        byArray2[351] = 1;
        byArray2[352] = -2;
        byArray2[354] = 63;
        byArray2[355] = -128;
        byArray2[358] = 1;
        byArray2[359] = -4;
        byArray2[361] = 127;
        byArray2[362] = -128;
        byArray2[367] = 3;
        byArray2[368] = -2;
        byArray2[370] = 63;
        byArray2[375] = -4;
        byArray2[377] = 127;
        byArray2[378] = -64;
        byArray2[383] = 3;
        byArray2[384] = -4;
        byArray2[386] = 127;
        byArray2[391] = -2;
        byArray2[393] = 63;
        byArray2[394] = -64;
        byArray2[399] = 7;
        byArray2[400] = -4;
        byArray2[402] = -2;
        byArray2[407] = 127;
        byArray2[409] = 63;
        byArray2[410] = -32;
        byArray2[415] = 7;
        byArray2[416] = -4;
        byArray2[418] = -2;
        byArray2[423] = 127;
        byArray2[425] = 63;
        byArray2[426] = -32;
        byArray2[431] = 7;
        byArray2[432] = -4;
        byArray2[433] = 1;
        byArray2[434] = -2;
        byArray2[439] = 127;
        byArray2[440] = -128;
        byArray2[441] = 63;
        byArray2[442] = -32;
        byArray2[447] = 15;
        byArray2[448] = -4;
        byArray2[449] = 1;
        byArray2[450] = -4;
        byArray2[455] = 63;
        byArray2[456] = -128;
        byArray2[457] = 63;
        byArray2[458] = -16;
        byArray2[463] = 15;
        byArray2[464] = -8;
        byArray2[465] = 3;
        byArray2[466] = -4;
        byArray2[471] = 63;
        byArray2[472] = -64;
        byArray2[473] = 31;
        byArray2[474] = -16;
        byArray2[479] = 15;
        byArray2[480] = -8;
        byArray2[481] = 3;
        byArray2[482] = -4;
        byArray2[487] = 63;
        byArray2[488] = -64;
        byArray2[489] = 31;
        byArray2[490] = -16;
        byArray2[495] = 15;
        byArray2[496] = -8;
        byArray2[497] = 3;
        byArray2[498] = -4;
        byArray2[503] = 63;
        byArray2[504] = -64;
        byArray2[505] = 31;
        byArray2[506] = -16;
        byArray2[511] = 15;
        byArray2[512] = -8;
        byArray2[513] = 3;
        byArray2[514] = -4;
        byArray2[519] = 63;
        byArray2[520] = -64;
        byArray2[521] = 31;
        byArray2[522] = -16;
        byArray2[527] = 15;
        byArray2[528] = -8;
        byArray2[529] = 3;
        byArray2[530] = -4;
        byArray2[535] = 63;
        byArray2[536] = -64;
        byArray2[537] = 31;
        byArray2[538] = -16;
        byArray2[543] = 15;
        byArray2[544] = -8;
        byArray2[545] = 3;
        byArray2[546] = -4;
        byArray2[548] = 3;
        byArray2[549] = -64;
        byArray2[551] = 63;
        byArray2[552] = -64;
        byArray2[553] = 31;
        byArray2[554] = -16;
        byArray2[559] = 15;
        byArray2[560] = -8;
        byArray2[561] = 3;
        byArray2[562] = -4;
        byArray2[564] = 7;
        byArray2[565] = -32;
        byArray2[567] = 63;
        byArray2[568] = -64;
        byArray2[569] = 31;
        byArray2[570] = -16;
        byArray2[575] = 15;
        byArray2[576] = -8;
        byArray2[577] = 3;
        byArray2[578] = -4;
        byArray2[580] = 15;
        byArray2[581] = -16;
        byArray2[583] = 63;
        byArray2[584] = -64;
        byArray2[585] = 31;
        byArray2[586] = -16;
        byArray2[591] = 15;
        byArray2[592] = -8;
        byArray2[593] = 3;
        byArray2[594] = -4;
        byArray2[596] = 31;
        byArray2[597] = -8;
        byArray2[599] = 63;
        byArray2[600] = -64;
        byArray2[601] = 31;
        byArray2[602] = -16;
        byArray2[607] = 15;
        byArray2[608] = -8;
        byArray2[609] = 3;
        byArray2[610] = -4;
        byArray2[612] = 63;
        byArray2[613] = -4;
        byArray2[615] = 63;
        byArray2[616] = -64;
        byArray2[617] = 31;
        byArray2[618] = -16;
        byArray2[623] = 15;
        byArray2[624] = -8;
        byArray2[625] = 3;
        byArray2[626] = -4;
        byArray2[628] = 63;
        byArray2[629] = -4;
        byArray2[631] = 63;
        byArray2[632] = -64;
        byArray2[633] = 31;
        byArray2[634] = -16;
        byArray2[639] = 15;
        byArray2[640] = -8;
        byArray2[641] = 3;
        byArray2[642] = -4;
        byArray2[644] = 63;
        byArray2[645] = -4;
        byArray2[647] = 63;
        byArray2[648] = -64;
        byArray2[649] = 31;
        byArray2[650] = -16;
        byArray2[655] = 15;
        byArray2[656] = -8;
        byArray2[657] = 3;
        byArray2[658] = -4;
        byArray2[660] = 31;
        byArray2[661] = -8;
        byArray2[663] = 63;
        byArray2[664] = -64;
        byArray2[665] = 31;
        byArray2[666] = -16;
        byArray2[671] = 15;
        byArray2[672] = -8;
        byArray2[673] = 3;
        byArray2[674] = -4;
        byArray2[676] = 15;
        byArray2[677] = -16;
        byArray2[679] = 63;
        byArray2[680] = -64;
        byArray2[681] = 31;
        byArray2[682] = -16;
        byArray2[687] = 15;
        byArray2[688] = -8;
        byArray2[689] = 3;
        byArray2[690] = -4;
        byArray2[692] = 7;
        byArray2[693] = -32;
        byArray2[695] = 63;
        byArray2[696] = -64;
        byArray2[697] = 31;
        byArray2[698] = -16;
        byArray2[703] = 15;
        byArray2[704] = -8;
        byArray2[705] = 1;
        byArray2[706] = -4;
        byArray2[708] = 3;
        byArray2[709] = -64;
        byArray2[711] = 63;
        byArray2[712] = -128;
        byArray2[713] = 31;
        byArray2[714] = -16;
        byArray2[719] = 15;
        byArray2[720] = -4;
        byArray2[721] = 1;
        byArray2[722] = -4;
        byArray2[727] = 63;
        byArray2[728] = -128;
        byArray2[729] = 63;
        byArray2[730] = -16;
        byArray2[735] = 7;
        byArray2[736] = -4;
        byArray2[738] = -2;
        byArray2[743] = 127;
        byArray2[744] = -128;
        byArray2[745] = 63;
        byArray2[746] = -32;
        byArray2[751] = 7;
        byArray2[752] = -4;
        byArray2[754] = -2;
        byArray2[757] = -128;
        byArray2[759] = 127;
        byArray2[761] = 63;
        byArray2[762] = -32;
        byArray2[767] = 7;
        byArray2[768] = -4;
        byArray2[770] = -2;
        byArray2[772] = 1;
        byArray2[773] = -64;
        byArray2[775] = 127;
        byArray2[777] = 63;
        byArray2[778] = -32;
        byArray2[783] = 3;
        byArray2[784] = -4;
        byArray2[786] = 127;
        byArray2[788] = 1;
        byArray2[789] = -64;
        byArray2[791] = -2;
        byArray2[793] = 63;
        byArray2[794] = -64;
        byArray2[799] = 3;
        byArray2[800] = -2;
        byArray2[802] = 63;
        byArray2[804] = 1;
        byArray2[805] = -64;
        byArray2[807] = -4;
        byArray2[809] = 127;
        byArray2[810] = -64;
        byArray2[815] = 1;
        byArray2[816] = -2;
        byArray2[818] = 63;
        byArray2[819] = -128;
        byArray2[820] = 1;
        byArray2[821] = -64;
        byArray2[822] = 1;
        byArray2[823] = -4;
        byArray2[825] = 127;
        byArray2[826] = -128;
        byArray2[831] = 1;
        byArray2[832] = -2;
        byArray2[834] = 31;
        byArray2[835] = -128;
        byArray2[836] = 3;
        byArray2[837] = -32;
        byArray2[838] = 1;
        byArray2[839] = -8;
        byArray2[841] = 127;
        byArray2[842] = -128;
        byArray2[848] = -1;
        byArray2[850] = 15;
        byArray2[851] = -128;
        byArray2[852] = 3;
        byArray2[853] = -32;
        byArray2[854] = 1;
        byArray2[855] = -16;
        byArray2[857] = -1;
        byArray2[864] = 127;
        byArray2[866] = 7;
        byArray2[867] = -64;
        byArray2[868] = 7;
        byArray2[869] = -16;
        byArray2[870] = 3;
        byArray2[871] = -32;
        byArray2[873] = -2;
        byArray2[880] = 127;
        byArray2[882] = 3;
        byArray2[883] = -64;
        byArray2[884] = 7;
        byArray2[885] = -16;
        byArray2[886] = 3;
        byArray2[887] = -64;
        byArray2[889] = -2;
        byArray2[896] = 63;
        byArray2[897] = -128;
        byArray2[898] = 1;
        byArray2[899] = -64;
        byArray2[900] = 7;
        byArray2[901] = -16;
        byArray2[902] = 3;
        byArray2[903] = -128;
        byArray2[904] = 1;
        byArray2[905] = -4;
        byArray2[912] = 31;
        byArray2[913] = -128;
        byArray2[915] = -64;
        byArray2[916] = 7;
        byArray2[917] = -16;
        byArray2[918] = 3;
        byArray2[920] = 1;
        byArray2[921] = -8;
        byArray2[928] = 15;
        byArray2[929] = -64;
        byArray2[932] = 7;
        byArray2[933] = -16;
        byArray2[936] = 3;
        byArray2[937] = -16;
        byArray2[944] = 7;
        byArray2[945] = -64;
        byArray2[948] = 15;
        byArray2[949] = -8;
        byArray2[952] = 3;
        byArray2[953] = -32;
        byArray2[960] = 3;
        byArray2[961] = -32;
        byArray2[964] = 15;
        byArray2[965] = -8;
        byArray2[968] = 7;
        byArray2[969] = -64;
        byArray2[976] = 1;
        byArray2[977] = -32;
        byArray2[980] = 15;
        byArray2[981] = -8;
        byArray2[984] = 7;
        byArray2[985] = -128;
        byArray2[993] = -32;
        byArray2[996] = 15;
        byArray2[997] = -8;
        byArray2[1000] = 7;
        byArray2[1009] = 96;
        byArray2[1012] = 15;
        byArray2[1013] = -8;
        byArray2[1016] = 6;
        byArray2[1025] = 32;
        byArray2[1028] = 31;
        byArray2[1029] = -4;
        byArray2[1032] = 4;
        byArray2[1044] = 31;
        byArray2[1045] = -4;
        byArray2[1060] = 63;
        byArray2[1061] = -2;
        byArray2[1076] = 63;
        byArray2[1077] = -2;
        byArray2[1092] = 63;
        byArray2[1093] = -2;
        byArray2[1108] = 63;
        byArray2[1109] = -2;
        byArray2[1124] = 127;
        byArray2[1125] = -1;
        byArray2[1140] = 127;
        byArray2[1141] = -1;
        byArray2[1156] = 127;
        byArray2[1157] = -1;
        byArray2[1172] = -1;
        byArray2[1173] = -1;
        byArray2[1174] = -128;
        byArray2[1188] = -1;
        byArray2[1189] = -1;
        byArray2[1190] = -128;
        byArray2[1204] = -1;
        byArray2[1205] = -1;
        byArray2[1206] = -128;
        byArray2[1220] = -1;
        byArray2[1221] = -1;
        byArray2[1222] = -128;
        byArray2[1235] = 1;
        byArray2[1236] = -1;
        byArray2[1237] = -1;
        byArray2[1238] = -64;
        byArray2[1251] = 1;
        byArray2[1252] = -1;
        byArray2[1253] = -1;
        byArray2[1254] = -64;
        byArray2[1267] = 1;
        byArray2[1268] = -1;
        byArray2[1269] = -1;
        byArray2[1270] = -64;
        byArray2[1283] = 1;
        byArray2[1284] = -1;
        byArray2[1285] = -1;
        byArray2[1286] = -64;
        byArray2[1299] = 1;
        byArray2[1300] = -1;
        byArray2[1301] = -1;
        byArray2[1302] = -64;
        byArray2[1315] = 3;
        byArray2[1316] = -1;
        byArray2[1317] = -1;
        byArray2[1318] = -32;
        byArray2[1331] = 3;
        byArray2[1332] = -1;
        byArray2[1333] = -1;
        byArray2[1334] = -32;
        byArray2[1347] = 7;
        byArray2[1348] = -1;
        byArray2[1349] = -1;
        byArray2[1350] = -16;
        byArray2[1363] = 7;
        byArray2[1364] = -1;
        byArray2[1365] = -1;
        byArray2[1366] = -16;
        byArray2[1379] = 7;
        byArray2[1380] = -1;
        byArray2[1381] = -1;
        byArray2[1382] = -16;
        byArray2[1395] = 7;
        byArray2[1396] = -1;
        byArray2[1397] = -1;
        byArray2[1398] = -16;
        byArray2[1411] = 7;
        byArray2[1412] = -1;
        byArray2[1413] = -1;
        byArray2[1414] = -16;
        byArray2[1427] = 15;
        byArray2[1428] = -1;
        byArray2[1429] = -1;
        byArray2[1430] = -8;
        byArray2[1443] = 15;
        byArray2[1444] = -1;
        byArray2[1445] = -1;
        byArray2[1446] = -8;
        byArray2[1459] = 15;
        byArray2[1460] = -1;
        byArray2[1461] = -1;
        byArray2[1462] = -8;
        byArray2[1475] = 15;
        byArray2[1476] = -1;
        byArray2[1477] = -1;
        byArray2[1478] = -8;
        byArray2[1491] = 31;
        byArray2[1492] = -1;
        byArray2[1493] = -1;
        byArray2[1494] = -4;
        byArray2[1507] = 31;
        byArray2[1508] = -1;
        byArray2[1509] = -1;
        byArray2[1510] = -4;
        byArray2[1523] = 31;
        byArray2[1524] = -1;
        byArray2[1525] = -1;
        byArray2[1526] = -4;
        byArray2[1539] = 31;
        byArray2[1540] = -1;
        byArray2[1541] = -1;
        byArray2[1542] = -4;
        byArray2[1555] = 63;
        byArray2[1556] = -1;
        byArray2[1557] = -1;
        byArray2[1558] = -2;
        byArray2[1571] = 63;
        byArray2[1572] = -1;
        byArray2[1573] = -1;
        byArray2[1574] = -2;
        byArray2[1587] = 63;
        byArray2[1588] = -1;
        byArray2[1589] = -1;
        byArray2[1590] = -2;
        byArray2[1603] = 63;
        byArray2[1604] = -1;
        byArray2[1605] = -1;
        byArray2[1606] = -2;
        byArray2[1619] = 127;
        byArray2[1620] = -1;
        byArray2[1621] = -1;
        byArray2[1622] = -1;
        byArray2[1635] = 127;
        byArray2[1636] = -1;
        byArray2[1637] = -1;
        byArray2[1638] = -1;
        byArray2[1651] = 127;
        byArray2[1652] = -1;
        byArray2[1653] = -1;
        byArray2[1654] = -1;
        byArray2[1667] = 127;
        byArray2[1668] = -1;
        byArray2[1669] = -1;
        byArray2[1670] = -1;
        byArray2[1683] = -1;
        byArray2[1684] = -1;
        byArray2[1685] = -1;
        byArray2[1686] = -1;
        byArray2[1687] = -128;
        byArray2[1699] = -1;
        byArray2[1700] = -1;
        byArray2[1701] = -1;
        byArray2[1702] = -1;
        byArray2[1703] = -128;
        byArray2[1715] = -1;
        byArray2[1716] = -1;
        byArray2[1717] = -1;
        byArray2[1718] = -1;
        byArray2[1719] = -128;
        byArray2[1731] = -1;
        byArray2[1732] = -1;
        byArray2[1733] = -1;
        byArray2[1734] = -1;
        byArray2[1735] = -128;
        byArray2[1746] = 1;
        byArray2[1747] = -1;
        byArray2[1748] = -1;
        byArray2[1749] = -1;
        byArray2[1750] = -1;
        byArray2[1751] = -64;
        byArray2[1762] = 1;
        byArray2[1763] = -1;
        byArray2[1764] = -1;
        byArray2[1765] = -1;
        byArray2[1766] = -1;
        byArray2[1767] = -64;
        byArray2[1778] = 1;
        byArray2[1779] = -1;
        byArray2[1780] = -1;
        byArray2[1781] = -1;
        byArray2[1782] = -1;
        byArray2[1783] = -64;
        byArray2[1794] = 1;
        byArray2[1795] = -1;
        byArray2[1796] = -1;
        byArray2[1797] = -1;
        byArray2[1798] = -1;
        byArray2[1799] = -64;
        byArray2[1810] = 3;
        byArray2[1811] = -1;
        byArray2[1812] = -1;
        byArray2[1813] = -1;
        byArray2[1814] = -1;
        byArray2[1815] = -32;
        byArray2[1826] = 3;
        byArray2[1827] = -1;
        byArray2[1828] = -1;
        byArray2[1829] = -1;
        byArray2[1830] = -1;
        byArray2[1831] = -32;
        byArray2[1842] = 3;
        byArray2[1843] = -1;
        byArray2[1844] = -1;
        byArray2[1845] = -1;
        byArray2[1846] = -1;
        byArray2[1847] = -32;
        byArray2[1858] = 7;
        byArray2[1859] = -1;
        byArray2[1860] = -1;
        byArray2[1861] = -1;
        byArray2[1862] = -1;
        byArray2[1863] = -16;
        byArray2[1874] = 7;
        byArray2[1875] = -1;
        byArray2[1876] = -1;
        byArray2[1877] = -1;
        byArray2[1878] = -1;
        byArray2[1879] = -16;
        byArray2[1890] = 7;
        byArray2[1891] = -1;
        byArray2[1892] = -1;
        byArray2[1893] = -1;
        byArray2[1894] = -1;
        byArray2[1895] = -16;
        byArray2[1906] = 15;
        byArray2[1907] = -1;
        byArray2[1908] = -1;
        byArray2[1909] = -1;
        byArray2[1910] = -1;
        byArray2[1911] = -8;
        byArray2[1922] = 15;
        byArray2[1923] = -1;
        byArray2[1924] = -1;
        byArray2[1925] = -1;
        byArray2[1926] = -1;
        byArray2[1927] = -8;
        byArray2[1938] = 31;
        byArray2[1939] = -1;
        byArray2[1940] = -1;
        byArray2[1941] = -1;
        byArray2[1942] = -1;
        byArray2[1943] = -4;
        byArray2[1954] = 31;
        byArray2[1955] = -1;
        byArray2[1956] = -1;
        byArray2[1957] = -1;
        byArray2[1958] = -1;
        byArray2[1959] = -4;
        byArray2[2061] = 10;
        byte[] bufTemp2 = byArray2;
        WifiPrintDriver.printByteData(bufTemp2);
        WifiPrintDriver.printString("");
        WifiPrintDriver.printParameterSet(new byte[]{27, 64});
        byte[] byArray3 = new byte[3];
        byArray3[0] = 27;
        byArray3[1] = 97;
        WifiPrintDriver.printParameterSet(byArray3);
    }
}

